
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GHEE</title>

    
    <!-- style page -->
    <link rel="stylesheet" href="assets/css/product.css">

    <!-- Favicon Image -->
    <link rel="icon" href="assets/images/logo/RF Ghee Logo Final (1).png">
    
    <meta name="title" content="RF Ghee Blog – Health, Recipes & Uses of Organic Cow Ghee"/>
    <meta name="description" content="Check out the RF Ghee blog for expert advice on the health benefits of ghee, creative recipes, and tips for using our pure, organic cow ghee in your life."/>

    <!-- FONT -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Lilita+One&display=swap" rel="stylesheet">

    <!-- Bootstrap cdn links -->
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">
    <script src="assets/bootstrap/js/bootstrap.bundle.js"></script>

    <!-- Font-awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src='https://kit.fontawesome.com/a076d05399.js' crossorigin='anonymous'></script>

    <!-- Owl Carousel -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">

    <!-- Bigger Slider -->
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/6.8.4/swiper-bundle.min.css">

     <!-- Owl Carousel -->
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.css">


      <style>
        body {
            overflow-x: hidden !important;
        }

        .text-h6 {
            color: #13428d;
        }

        .acc-det a {
            color: #1a1a1a;
            text-decoration: underline !important;
        }

        a:hover {
            color: #13428d;
        }

        .text-h5 {
            min-width: 140px;
            margin: 0;
            font-family: "Lilita One", sans-serif;
            font-size: 20px;
            line-height: 1em;
            font-weight: 600;
            color: #1a1a1a;
            margin-bottom: 15px;
        }
         .order-message{
            margin-bottom: 15px;
         }

         .custom-btn-1 {
            margin-bottom: 15px;
         }

         p {
            font-weight: 400;
         }
        
         .reg-user {
            position: relative;
            padding: 30px;
            max-width: 700px;
            margin: auto;
            display: flex;
            flex-flow: column;
            background-color: #f7f7f7;
            border-radius: 30px;
            border: none !important;
         }

      .dt-sc-btn-group {
        display: grid
;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    column-gap: 30px;
      }

      .img-container {
        width: 20%;
      }
      .img-container img {
        width: 90%;
        border-radius: 10px;
      }

      .detail-text {
        width: 80%;
      }

      .text-id {
        color: #333;
        font-weight: 600;
        font-size: 17px;
      }

      .detail-link a {
        color: gray;
        font-size: 14px;
      }

      .dropdown-menu a {
        text-decoration: none !important;
      }

      .btn-secondary {
        background-color: transparent !important;
        color: gray;
        border: none;
      }

      .btn-secondary:focus {
        color: gray;
      }
      </style>

</head>
<body>
<?php
    include('header.php');
    ?>

   <!-- Section-4 START -->
<div class="section-4-index">
    <div class="section-4-banner" style="background-image: url('assets/images/banner/home-background-image-05.webp');">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <h2 class="text-h3">
                        HISTORY
                    </h2>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Section-4 END -->


<div class="acc-det">
    <div class="container">
        <div class="reg-user">
            <div class="d-flex justify-content-between">
                <div>
                    <h6 class="text-h5" style="">Order History</h6>
                </div>
                <!-- <div class="container "> -->
                    <div class="dropdown">
                        <button id="dropdownBtn" class="btn btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Sort
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" data-value="Action">Action</a></li>
                            <li><a class="dropdown-item" href="#" data-value="Another action">Another action</a></li>
                            <li><a class="dropdown-item" href="#" data-value="Something else">Something else here</a></li>
                        </ul>
                    </div>
                <!-- </div> -->
            </div>
            <script>
                document.querySelectorAll(".dropdown-item").forEach(item => {
                    item.addEventListener("click", function(event) {
                        event.preventDefault(); // Prevent default link behavior
                        document.getElementById("dropdownBtn").textContent = this.textContent;
                    });
                });
            </script>


            <div class="account-details" style="text-align: left;">
            <p class="order-message">You haven't placed any orders yet.</p>
                <!-- <div class="date-det">
                    <p class="date-txt">25/03/2025</p>
                    <div class="d-flex justify-content-between">
                        <div class="text-id">#XYZ24DR</div>
                        <div class="detail-link">
                            <a href="">Details<i class="fa fa-angle-right"></i></a>
                        </div>
                    </div>
                    <div class="d-flex">
                        <div class="img-container">
                            <img src="assets/images/blog/blog-01.webp" alt="">
                        </div>
                        <div class="detail-text">
                            <p>Air Force One</p>
                            <p>Quantity:&nbsp;<span>1</span> | ₹<span>99</span></p>
                        </div>
                    </div>
                    <hr>
                </div>
                <div class="date-det">
                    <p class="date-txt">25/03/2025</p>
                    <div class="d-flex justify-content-between">
                        <div class="text-id">#XYZ24DR</div>
                        <div class="detail-link">
                            <a href="">Details<i class="fa fa-angle-right"></i></a>
                        </div>
                    </div>
                    <div class="d-flex">
                        <div class="img-container">
                            <img src="assets/images/blog/blog-03.webp" alt="">
                        </div>
                        <div class="detail-text">
                            <p>Air Force One</p>
                            <p>Quantity:&nbsp;<span>1</span> | ₹<span>99</span></p>
                        </div>
                    </div>
                    <br>
                    <div class="d-flex">
                        <div class="img-container">
                            <img src="assets/images/blog/blog-03.webp" alt="">
                        </div>
                        <div class="detail-text">
                            <p>Air Force One</p>
                            <p>Quantity:&nbsp;<span>1</span> | ₹<span>99</span></p>
                        </div>
                    </div>
                    <hr>
                </div>
                <div class="date-det">
                    <p class="date-txt">25/03/2025</p>
                    <div class="d-flex justify-content-between">
                        <div class="text-id">#XYZ24DR</div>
                        <div class="detail-link">
                            <a href="">Details<i class="fa fa-angle-right"></i></a>
                        </div>
                    </div>
                    <div class="d-flex">
                        <div class="img-container">
                            <img src="assets/images/blog/blog-5.webp" alt="">
                        </div>
                        <div class="detail-text">
                            <p>Air Force One</p>
                            <p>Quantity:&nbsp;<span>1</span> | ₹<span>99</span></p>
                        </div>
                    </div>
                    <hr>
                </div> -->
            </div>
        </div>
    </div>
</div>

    <!-- Footer Section START -->
    <footer class="footer" style="background-image: url('assets/images/banner/footer-image-01.webp');">
        <div class="container">
            <div class="row">
                <div class="col-lgs-4 col-md-4 col-sm-12 col-12 first-col-footer">
                    <div class="logo-img">
                        <img src="assets/images/logo/RF Ghee Logo Final (1).png" alt="" style="width: 40%;">
                    </div><br>
                    <h4 class="text-h4">Follow Us:</h4>
                    <i class="fab fa-twitter"></i>
                    <i class="fab fa-facebook"></i>
                    <i class="fab fa-instagram"></i>
                    <i class="fab fa-linkedin"></i>
                </div>
                <div class="col-lgs-4 col-md-4 col-sm-12  col-12 first-col-footer" style="justify-content: center; align-items: center;">
                    <p class="text-p">info@example.com</p>
                    <p class="text-p">Call us: (0000) 123456789</p>
                    <p class="text-p">No. 58 A, East Madison Street,<br> Baltimore, MD, USA 4508</p>
                </div>
                <div class="col-lgs-4 col-md-4 col-sm-12 col-12 second-col-footer" style="display: flex; justify-content: center; align-items: center;">
                    <div class="wrap">
                        <div class="search">
                           <input type="text" class="searchTerm" placeholder="Your email address">
                           <button type="submit" class="searchButton">
                             SUBSCRIBE
                          </button>
                        </div>
                     </div>
                </div>
            </div>
            <br>
            <hr>
            <div class="row">
                <div class="col-md-4 text-left text-dark">
                    &copy; 2024 Ghee-theme Design Themes
                </div>
                <div class="col-md-4">
                    <ul class="d-flex mobile-res">
                        <li><a href="privacy-policy.php">Privacy Policy</a></li>&nbsp; &nbsp; &nbsp; &nbsp;
                        <li><a href="terms.php">Terms</a></li>
                    </ul>
                </div>
                <div class="col-md-4 mobile-res" style="display: flex; align-items: center; justify-content: center;">
                    <ul class="d-flex text-center align-items-center   " >
              
                        <li class="icon--payment">
                          <svg viewBox="0 0 38 24" xmlns="http://www.w3.org/2000/svg" role="img" width="38" height="24" aria-labelledby="pi-visa"><title id="pi-visa">Visa</title><path opacity=".07" d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z"/><path fill="#fff" d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32"/><path d="M28.3 10.1H28c-.4 1-.7 1.5-1 3h1.9c-.3-1.5-.3-2.2-.6-3zm2.9 5.9h-1.7c-.1 0-.1 0-.2-.1l-.2-.9-.1-.2h-2.4c-.1 0-.2 0-.2.2l-.3.9c0 .1-.1.1-.1.1h-2.1l.2-.5L27 8.7c0-.5.3-.7.8-.7h1.5c.1 0 .2 0 .2.2l1.4 6.5c.1.4.2.7.2 1.1.1.1.1.1.1.2zm-13.4-.3l.4-1.8c.1 0 .2.1.2.1.7.3 1.4.5 2.1.4.2 0 .5-.1.7-.2.5-.2.5-.7.1-1.1-.2-.2-.5-.3-.8-.5-.4-.2-.8-.4-1.1-.7-1.2-1-.8-2.4-.1-3.1.6-.4.9-.8 1.7-.8 1.2 0 2.5 0 3.1.2h.1c-.1.6-.2 1.1-.4 1.7-.5-.2-1-.4-1.5-.4-.3 0-.6 0-.9.1-.2 0-.3.1-.4.2-.2.2-.2.5 0 .7l.5.4c.4.2.8.4 1.1.6.5.3 1 .8 1.1 1.4.2.9-.1 1.7-.9 2.3-.5.4-.7.6-1.4.6-1.4 0-2.5.1-3.4-.2-.1.2-.1.2-.2.1zm-3.5.3c.1-.7.1-.7.2-1 .5-2.2 1-4.5 1.4-6.7.1-.2.1-.3.3-.3H18c-.2 1.2-.4 2.1-.7 3.2-.3 1.5-.6 3-1 4.5 0 .2-.1.2-.3.2M5 8.2c0-.1.2-.2.3-.2h3.4c.5 0 .9.3 1 .8l.9 4.4c0 .1 0 .1.1.2 0-.1.1-.1.1-.1l2.1-5.1c-.1-.1 0-.2.1-.2h2.1c0 .1 0 .1-.1.2l-3.1 7.3c-.1.2-.1.3-.2.4-.1.1-.3 0-.5 0H9.7c-.1 0-.2 0-.2-.2L7.9 9.5c-.2-.2-.5-.5-.9-.6-.6-.3-1.7-.5-1.9-.5L5 8.2z" fill="#142688"/></svg>
                        </li>
                        
                        <li class="icon--payment">
                          <svg viewBox="0 0 38 24" xmlns="http://www.w3.org/2000/svg" role="img" width="38" height="24" aria-labelledby="pi-master"><title id="pi-master">Mastercard</title><path opacity=".07" d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z"/><path fill="#fff" d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32"/><circle fill="#EB001B" cx="15" cy="12" r="7"/><circle fill="#F79E1B" cx="23" cy="12" r="7"/><path fill="#FF5F00" d="M22 12c0-2.4-1.2-4.5-3-5.7-1.8 1.3-3 3.4-3 5.7s1.2 4.5 3 5.7c1.8-1.2 3-3.3 3-5.7z"/></svg>
                        </li>
                        
                        <li class="icon--payment">
                          <svg xmlns="http://www.w3.org/2000/svg" role="img" aria-labelledby="pi-american_express" viewBox="0 0 38 24" width="38" height="24"><title id="pi-american_express">American Express</title><path fill="#000" d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3Z" opacity=".07"/><path fill="#006FCF" d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32Z"/><path fill="#FFF" d="M22.012 19.936v-8.421L37 11.528v2.326l-1.732 1.852L37 17.573v2.375h-2.766l-1.47-1.622-1.46 1.628-9.292-.02Z"/><path fill="#006FCF" d="M23.013 19.012v-6.57h5.572v1.513h-3.768v1.028h3.678v1.488h-3.678v1.01h3.768v1.531h-5.572Z"/><path fill="#006FCF" d="m28.557 19.012 3.083-3.289-3.083-3.282h2.386l1.884 2.083 1.89-2.082H37v.051l-3.017 3.23L37 18.92v.093h-2.307l-1.917-2.103-1.898 2.104h-2.321Z"/><path fill="#FFF" d="M22.71 4.04h3.614l1.269 2.881V4.04h4.46l.77 2.159.771-2.159H37v8.421H19l3.71-8.421Z"/><path fill="#006FCF" d="m23.395 4.955-2.916 6.566h2l.55-1.315h2.98l.55 1.315h2.05l-2.904-6.566h-2.31Zm.25 3.777.875-2.09.873 2.09h-1.748Z"/><path fill="#006FCF" d="M28.581 11.52V4.953l2.811.01L32.84 9l1.456-4.046H37v6.565l-1.74.016v-4.51l-1.644 4.494h-1.59L30.35 7.01v4.51h-1.768Z"/></svg>
          
                        </li>
                        
                        <li class="icon--payment">
                          <svg viewBox="0 0 38 24" xmlns="http://www.w3.org/2000/svg" width="38" height="24" role="img" aria-labelledby="pi-paypal"><title id="pi-paypal">PayPal</title><path opacity=".07" d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z"/><path fill="#fff" d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32"/><path fill="#003087" d="M23.9 8.3c.2-1 0-1.7-.6-2.3-.6-.7-1.7-1-3.1-1h-4.1c-.3 0-.5.2-.6.5L14 15.6c0 .2.1.4.3.4H17l.4-3.4 1.8-2.2 4.7-2.1z"/><path fill="#3086C8" d="M23.9 8.3l-.2.2c-.5 2.8-2.2 3.8-4.6 3.8H18c-.3 0-.5.2-.6.5l-.6 3.9-.2 1c0 .2.1.4.3.4H19c.3 0 .5-.2.5-.4v-.1l.4-2.4v-.1c0-.2.3-.4.5-.4h.3c2.1 0 3.7-.8 4.1-3.2.2-1 .1-1.8-.4-2.4-.1-.5-.3-.7-.5-.8z"/><path fill="#012169" d="M23.3 8.1c-.1-.1-.2-.1-.3-.1-.1 0-.2 0-.3-.1-.3-.1-.7-.1-1.1-.1h-3c-.1 0-.2 0-.2.1-.2.1-.3.2-.3.4l-.7 4.4v.1c0-.3.3-.5.6-.5h1.3c2.5 0 4.1-1 4.6-3.8v-.2c-.1-.1-.3-.2-.5-.2h-.1z"/></svg>
                        </li>
                        
                        <li class="icon--payment">
                          <svg viewBox="0 0 38 24" xmlns="http://www.w3.org/2000/svg" role="img" width="38" height="24" aria-labelledby="pi-diners_club"><title id="pi-diners_club">Diners Club</title><path opacity=".07" d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z"/><path fill="#fff" d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32"/><path d="M12 12v3.7c0 .3-.2.3-.5.2-1.9-.8-3-3.3-2.3-5.4.4-1.1 1.2-2 2.3-2.4.4-.2.5-.1.5.2V12zm2 0V8.3c0-.3 0-.3.3-.2 2.1.8 3.2 3.3 2.4 5.4-.4 1.1-1.2 2-2.3 2.4-.4.2-.4.1-.4-.2V12zm7.2-7H13c3.8 0 6.8 3.1 6.8 7s-3 7-6.8 7h8.2c3.8 0 6.8-3.1 6.8-7s-3-7-6.8-7z" fill="#3086C8"/></svg>
                        </li>
                        
                        <li class="icon--payment">
                          <svg viewBox="0 0 38 24" width="38" height="24" role="img" aria-labelledby="pi-discover" fill="none" xmlns="http://www.w3.org/2000/svg"><title id="pi-discover">Discover</title><path fill="#000" opacity=".07" d="M35 0H3C1.3 0 0 1.3 0 3v18c0 1.7 1.4 3 3 3h32c1.7 0 3-1.3 3-3V3c0-1.7-1.4-3-3-3z"/><path d="M35 1c1.1 0 2 .9 2 2v18c0 1.1-.9 2-2 2H3c-1.1 0-2-.9-2-2V3c0-1.1.9-2 2-2h32z" fill="#fff"/><path d="M3.57 7.16H2v5.5h1.57c.83 0 1.43-.2 1.96-.63.63-.52 1-1.3 1-2.11-.01-1.63-1.22-2.76-2.96-2.76zm1.26 4.14c-.34.3-.77.44-1.47.44h-.29V8.1h.29c.69 0 1.11.12 1.47.44.37.33.59.84.59 1.37 0 .53-.22 1.06-.59 1.39zm2.19-4.14h1.07v5.5H7.02v-5.5zm3.69 2.11c-.64-.24-.83-.4-.83-.69 0-.35.34-.61.8-.61.32 0 .59.13.86.45l.56-.73c-.46-.4-1.01-.61-1.62-.61-.97 0-1.72.68-1.72 1.58 0 .76.35 1.15 1.35 1.51.42.15.63.25.74.31.21.14.32.34.32.57 0 .45-.35.78-.83.78-.51 0-.92-.26-1.17-.73l-.69.67c.49.73 1.09 1.05 1.9 1.05 1.11 0 1.9-.74 1.9-1.81.02-.89-.35-1.29-1.57-1.74zm1.92.65c0 1.62 1.27 2.87 2.9 2.87.46 0 .86-.09 1.34-.32v-1.26c-.43.43-.81.6-1.29.6-1.08 0-1.85-.78-1.85-1.9 0-1.06.79-1.89 1.8-1.89.51 0 .9.18 1.34.62V7.38c-.47-.24-.86-.34-1.32-.34-1.61 0-2.92 1.28-2.92 2.88zm12.76.94l-1.47-3.7h-1.17l2.33 5.64h.58l2.37-5.64h-1.16l-1.48 3.7zm3.13 1.8h3.04v-.93h-1.97v-1.48h1.9v-.93h-1.9V8.1h1.97v-.94h-3.04v5.5zm7.29-3.87c0-1.03-.71-1.62-1.95-1.62h-1.59v5.5h1.07v-2.21h.14l1.48 2.21h1.32l-1.73-2.32c.81-.17 1.26-.72 1.26-1.56zm-2.16.91h-.31V8.03h.33c.67 0 1.03.28 1.03.82 0 .55-.36.85-1.05.85z" fill="#231F20"/><path d="M20.16 12.86a2.931 2.931 0 100-5.862 2.931 2.931 0 000 5.862z" fill="url(#pi-paint0_linear)"/><path opacity=".65" d="M20.16 12.86a2.931 2.931 0 100-5.862 2.931 2.931 0 000 5.862z" fill="url(#pi-paint1_linear)"/><path d="M36.57 7.506c0-.1-.07-.15-.18-.15h-.16v.48h.12v-.19l.14.19h.14l-.16-.2c.06-.01.1-.06.1-.13zm-.2.07h-.02v-.13h.02c.06 0 .09.02.09.06 0 .05-.03.07-.09.07z" fill="#231F20"/><path d="M36.41 7.176c-.23 0-.42.19-.42.42 0 .23.19.42.42.42.23 0 .42-.19.42-.42 0-.23-.19-.42-.42-.42zm0 .77c-.18 0-.34-.15-.34-.35 0-.19.15-.35.34-.35.18 0 .33.16.33.35 0 .19-.15.35-.33.35z" fill="#231F20"/><path d="M37 12.984S27.09 19.873 8.976 23h26.023a2 2 0 002-1.984l.024-3.02L37 12.985z" fill="#F48120"/><defs><linearGradient id="pi-paint0_linear" x1="21.657" y1="12.275" x2="19.632" y2="9.104" gradientUnits="userSpaceOnUse"><stop stop-color="#F89F20"/><stop offset=".25" stop-color="#F79A20"/><stop offset=".533" stop-color="#F68D20"/><stop offset=".62" stop-color="#F58720"/><stop offset=".723" stop-color="#F48120"/><stop offset="1" stop-color="#F37521"/></linearGradient><linearGradient id="pi-paint1_linear" x1="21.338" y1="12.232" x2="18.378" y2="6.446" gradientUnits="userSpaceOnUse"><stop stop-color="#F58720"/><stop offset=".359" stop-color="#E16F27"/><stop offset=".703" stop-color="#D4602C"/><stop offset=".982" stop-color="#D05B2E"/></linearGradient></defs></svg>
                        </li>
                        
                      </ul>
                </div>
            </div>
        </div>
    </footer>
    <!-- Footer Section END -->

     <!-- JQuery -->
     <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
      <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.2.2/jquery.min.js"></script>
     <script src="https://stackpath.bootstrapcdn.com/bootstrap/5.1.3/js/bootstrap.bundle.min.js"></script>
     <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/6.8.4/swiper-bundle.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.js"></script>

    <script src="assets/js/owl-carousel.js"></script>
    <script src="assets/js/sidebar.js"></script>

    <script>
        $('#owl-carousel').owlCarousel({
            loop: false,
            margin: 30,
            dots: false,
            nav: true,
            items: 1,
        })
    </script>
    
        <script>
document.addEventListener('DOMContentLoaded', function() {
    // Get user ID from URL parameters
    const urlParams = new URLSearchParams(window.location.search);
    const userId = urlParams.get('id');
    
    if (!userId) {
        document.querySelector('.account-details').innerHTML = 
            '<p>User ID not found in URL parameters</p>';
        return;
    }
    
    // Fetch order data
    fetch(`http://localhost/hapi%20commers/api/getorderbycustomerid-api.php?user_id=${userId}`)
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            if (data.status === 'success') {
                displayOrders(data.data);
            } else {
                console.error('Error:', data.message);
                document.querySelector('.account-details').innerHTML = 
                    '<p>Error loading orders: ' + data.message + '</p>';
            }
        })
        .catch(error => {
            console.error('Error fetching orders:', error);
            document.querySelector('.account-details').innerHTML = 
                '<p>Error loading orders. Please try again.</p>';
        });

    function displayOrders(orders) {
        const container = document.querySelector('.account-details');
        container.innerHTML = ''; // Clear existing content

        // Group orders by date
        const ordersByDate = {};
        orders.forEach(order => {
            const date = order.order_date.split(' ')[0]; // Get just the date part
            if (!ordersByDate[date]) {
                ordersByDate[date] = [];
            }
            ordersByDate[date].push(order);
        });

        // Create HTML for each date group
        for (const [date, dateOrders] of Object.entries(ordersByDate)) {
            const dateElement = document.createElement('div');
            dateElement.className = 'date-det';
            
            // Format date as DD/MM/YYYY
            const formattedDate = formatDate(date);
            
            dateElement.innerHTML = `
                <p class="date-txt">${formattedDate}</p>
            `;

            // Add each order for this date
            dateOrders.forEach(order => {
                const orderElement = document.createElement('div');
                orderElement.innerHTML = `
                    <div class="d-flex justify-content-between">
                        <div class="text-id">#${order.order_no}</div>
                        <div class="detail-link">
                            <a href="order-details.php?id=${order.order_id}">Details<i class="fa fa-angle-right"></i></a>
                        </div>
                    </div>
                `;

                // Add products for this order
                order.products.forEach(product => {
                    const productElement = document.createElement('div');
                    productElement.className = 'd-flex';
                    productElement.innerHTML = `
                        <div class="img-container">
                            <img src="${product.product_image}" alt="${product.product_name}">
                        </div>
                        <div class="detail-text">
                            <p>${product.product_name}</p>
                            <p>Quantity:&nbsp;<span>${product.quantity}| ₹<span>&nbsp;${product.product_total}</span></p>
                        </div>
                    `;
                    orderElement.appendChild(productElement);
                    orderElement.appendChild(document.createElement('br'));
                });

                dateElement.appendChild(orderElement);
                dateElement.appendChild(document.createElement('hr'));
            });

            container.appendChild(dateElement);
        }
    }

    function formatDate(dateString) {
        const date = new Date(dateString);
        const day = String(date.getDate()).padStart(2, '0');
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const year = date.getFullYear();
        return `${day}/${month}/${year}`;
    }
});
    </script>

</body>
</html>